// this contains shared functions that are useful whether it is in the  context of skills, effects or items

// iterates over a dictionary object, returning a boolean indicating if a key is present
// required as dictionary.get(booleanFlag) doesn't return a true or false but a null regardless of whether it is actually there or not
function vicDictionaryHasKey(dictionary, myKey)
{
var keys = dictionary.keys;

for (var i=0; i<keys.length; i++)
{
if (keys[i] == myKey) return true;
}

return false;
}

// gets the type of an object as a string, using the built-in c# methods, removing the Ian. prefix if found and converting all to lowercase
function vicGetType(obj)
{
var type = obj.GetType().ToString();
var type = type.split("Ian."); // last element of the array should be what we want
var type = type[type.length-1];
return type.toLowerCase();
}

// returns the target of the skill/effect/item object. Target can either be either "tile" or "unit". Throws an exception if it cannot be determined
function vicGetTarget(obj)
{
if (obj == null) return null;
var isTile = (vicDictionaryHasKey(obj.AllFlags, "tile") || vicDictionaryHasKey(obj.AllFlags, "empty_tile"));
var isUnit = (vicDictionaryHasKey(obj.AllFlags, "unit") || vicDictionaryHasKey(obj.AllFlags, "self") || vicDictionaryHasKey(obj.AllFlags, "enemy") || vicDictionaryHasKey(obj.AllFlags, "friendly") || vicDictionaryHasKey(obj.AllFlags, "no_self_cast"));

if (isTile) return "tile";
if (isUnit) return "unit";

throw "Could not determine whether the " + vicGetType(obj) + " " + obj.IndexedName + " has a tile or unit as its target.";
}

